VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   6615
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   8205
   LinkTopic       =   "Form1"
   ScaleHeight     =   6615
   ScaleWidth      =   8205
   StartUpPosition =   3  'Windows-Standard
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Cairo As New cCairo

Private Sub Form_Load()
  Caption = "Click Me!"
End Sub

Private Sub Form_Click()

  Dim Srf As cCairoSurface
  'now we allocate a Surface, which matches with our Forms initial Client-Area
  Me.ScaleMode = vbPixels
  Set Srf = Cairo.CreateSurface(Me.ScaleWidth, Me.ScaleHeight, ImageSurface)
  
  
  Dim CC As cCairoContext
  Set CC = Srf.CreateContext
  
  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint
  
  
  'Ok, first some unscaled output, using basically the drawing-commands from our
  'Hello-World Demo - this time "hosted" within a Sub-Routine
  DrawGroupOn CC, "Scale: 1"


  'now scaled to twice the size, and also translated by 90 Pixels in y-Direction
  'the nesting between CC.Save and CC.Restore ensures, that we don't "mess-up"
  'the original Transformation-Matrix on our CC ... after "popping up" from a
  'CC.Restore, everything will be "as before" on our Cairo-Drawing-Context
  CC.Save
    CC.TranslateDrawings 0, 90
    CC.ScaleDrawings 2, 2
    
    DrawGroupOn CC, "Scale: 2"
  CC.Restore
  
  
  'finally a Scale half the original size, also translated and this time also rotated
  CC.Save
    CC.TranslateDrawings 50, 280
    CC.ScaleDrawings 0.5, 0.5
    CC.RotateDrawingsDeg 45
    
    DrawGroupOn CC, "Scale: 0.5"
    
    'and to visualize the Point which we rotated on:
    '(this is always the Point(0,0), but (0,0) is relative to our currently
    'set Translation, which in this case was: CC.TranslateDrawings 50, 280)
    CC.Arc 0, 0, 10 'define the path... (a circular one this time, with a Radius 10, Center at (0,0))
    CC.SetSourceColor vbBlue, 0.5 'define a Color, this time with 50%Alpha-Transparency
    CC.Fill 'and fill the Path
  CC.Restore
  
  Srf.DrawToDC hDC
End Sub


'Note, that the coord-params in this Sub-Function do not need to be changed
'they respect the current Transformations on our CC, set beforehand (from "outside")
Private Sub DrawGroupOn(CC As cCairoContext, Text As String)
  CC.Rectangle 0, 0, 200, 80

  CC.SetSourceColor vbYellow
  CC.Fill

  CC.SelectFont "Times New Roman", 30, vbRed
  CC.TextOut 15, 20, Text
End Sub
